package com.ejie.aa17a.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.ejie.aa17a.utilidades.Aa17aConstantes;
import com.ejie.x38.serialization.JsonDateDeserializer;
import com.ejie.x38.serialization.JsonDateSerializer;
import com.ejie.x38.serialization.JsonDateTimeDeserializer;
import com.ejie.x38.serialization.JsonDateTimeSerializer;

/**
 * Aa17aDatoHorario generated by UDA, 18-dic-2013 15:36:12.
 * 
 * @author UDA
 */

public class Aa17aDatoHorario implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	//Clave compuesta
	private Long idEstacion;
	private String nombreEstacion;
	private Aa17aContaminante contaminante;
	private Date fechaDato;
	private BigDecimal valorHora01;
	private BigDecimal valorHora02;
	private BigDecimal valorHora03;
	private BigDecimal valorHora04;
	private BigDecimal valorHora05;
	private BigDecimal valorHora06;
	private BigDecimal valorHora07;
	private BigDecimal valorHora08;
	private BigDecimal valorHora09;
	private BigDecimal valorHora10;
	private BigDecimal valorHora11;
	private BigDecimal valorHora12;
	private BigDecimal valorHora13;
	private BigDecimal valorHora14;
	private BigDecimal valorHora15;
	private BigDecimal valorHora16;
	private BigDecimal valorHora17;
	private BigDecimal valorHora18;
	private BigDecimal valorHora19;
	private BigDecimal valorHora20;
	private BigDecimal valorHora21;
	private BigDecimal valorHora22;
	private BigDecimal valorHora23;
	private BigDecimal valorHora24;
	private List<Long> listaContaminantes; //lista de id de contaminante. Utilizado para el filtro en las pantallas de los graficos 
	private List<BigDecimal> listaValores; //todos los valores de cada hora metidos en una lista. Necesario en este formato para cargar el grafico
	private Date ultimaMedidaHoraria; //fecha hora de la ultima medicion
	private BigDecimal ultimoValorHorario; //valor de la ultima medicion
	private Aa17aBanda banda;
	private String fechaHoraUltimaMedidaHoraria; //fecha y hora de la última medición en formato String

	//filtros de fechas utilizadas en la pantalla de datos historicos cuando se genera un informe
	private Date fechaDesde;
	private Date fechaHasta;

	/**
	 * Method 'Aa17aDatoHorario'.
	 */
	public Aa17aDatoHorario() {
	}

	/**
	 * Method 'getIdEstacion'.
	 * 
	 * @return Long
	 */

	public Long getIdEstacion() {
		return this.idEstacion;
	}

	/**
	 * Method 'setIdEstacion'.
	 * 
	 * @param idEstacion
	 *            Long
	 * @return
	 */

	public void setIdEstacion(Long idEstacion) {
		this.idEstacion = idEstacion;
	}

	/**
	 * @return the nombreEstacion
	 */
	public String getNombreEstacion() {
		return this.nombreEstacion;
	}

	/**
	 * @param nombreEstacion
	 *            the nombreEstacion to set
	 */
	public void setNombreEstacion(String nombreEstacion) {
		this.nombreEstacion = nombreEstacion;
	}

	/**
	 * Method 'getIdContaminante'.
	 * 
	 * @return Long
	 */

	/*public Long getIdContaminante() {
		return this.idContaminante;
	}*/

	/**
	 * Method 'setIdContaminante'.
	 * 
	 * @param idContaminante
	 *            Long
	 * @return
	 */

	/*public void setIdContaminante(Long idContaminante) {
		this.idContaminante = idContaminante;
	}*/

	/**
	 * @return the nombreContaminante
	 */
	/*public String getNombreContaminante() {
		return this.nombreContaminante;
	}*/

	/**
	 * @param nombreContaminante
	 *            the nombreContaminante to set
	 */
	/*public void setNombreContaminante(String nombreContaminante) {
		this.nombreContaminante = nombreContaminante;
	}*/

	/**
	 * @return the unidadMedida
	 */
	/*public String getUnidadMedida() {
		return this.unidadMedida;
	}
	*/
	/**
	 * @param unidadMedida
	 *            the unidadMedida to set
	 */
	/*public void setUnidadMedida(String unidadMedida) {
		this.unidadMedida = unidadMedida;
	}*/

	/**
	 * @return the contaminante
	 */
	public Aa17aContaminante getContaminante() {
		return this.contaminante;
	}

	/**
	 * @param contaminante
	 *            the contaminante to set
	 */
	public void setContaminante(Aa17aContaminante contaminante) {
		this.contaminante = contaminante;
	}

	/**
	 * Method 'getFechaDato'.
	 * 
	 * @return Date
	 */

	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaDato() {
		return this.fechaDato;
	}

	/**
	 * Method 'setFechaDato'.
	 * 
	 * @param fechaDato
	 *            Date
	 * @return
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaDato(Date fechaDato) {
		this.fechaDato = fechaDato;
	}

	/**
	 * Method 'getValorHora24'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora24() {
		return this.valorHora24;
	}

	/**
	 * Method 'setValorHora00'.
	 * 
	 * @param valorHora24
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora24(BigDecimal valorHora24) {
		this.valorHora24 = valorHora24;
	}

	/**
	 * Method 'getValorHora01'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora01() {
		return this.valorHora01;
	}

	/**
	 * Method 'setValorHora01'.
	 * 
	 * @param valorHora01
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora01(BigDecimal valorHora01) {
		this.valorHora01 = valorHora01;
	}

	/**
	 * Method 'getValorHora02'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora02() {
		return this.valorHora02;
	}

	/**
	 * Method 'setValorHora02'.
	 * 
	 * @param valorHora02
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora02(BigDecimal valorHora02) {
		this.valorHora02 = valorHora02;
	}

	/**
	 * Method 'getValorHora03'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora03() {
		return this.valorHora03;
	}

	/**
	 * Method 'setValorHora03'.
	 * 
	 * @param valorHora03
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora03(BigDecimal valorHora03) {
		this.valorHora03 = valorHora03;
	}

	/**
	 * Method 'getValorHora04'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora04() {
		return this.valorHora04;
	}

	/**
	 * Method 'setValorHora04'.
	 * 
	 * @param valorHora04
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora04(BigDecimal valorHora04) {
		this.valorHora04 = valorHora04;
	}

	/**
	 * Method 'getValorHora05'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora05() {
		return this.valorHora05;
	}

	/**
	 * Method 'setValorHora05'.
	 * 
	 * @param valorHora05
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora05(BigDecimal valorHora05) {
		this.valorHora05 = valorHora05;
	}

	/**
	 * Method 'getValorHora06'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora06() {
		return this.valorHora06;
	}

	/**
	 * Method 'setValorHora06'.
	 * 
	 * @param valorHora06
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora06(BigDecimal valorHora06) {
		this.valorHora06 = valorHora06;
	}

	/**
	 * Method 'getValorHora07'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora07() {
		return this.valorHora07;
	}

	/**
	 * Method 'setValorHora07'.
	 * 
	 * @param valorHora07
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora07(BigDecimal valorHora07) {
		this.valorHora07 = valorHora07;
	}

	/**
	 * Method 'getValorHora08'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora08() {
		return this.valorHora08;
	}

	/**
	 * Method 'setValorHora08'.
	 * 
	 * @param valorHora08
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora08(BigDecimal valorHora08) {
		this.valorHora08 = valorHora08;
	}

	/**
	 * Method 'getValorHora09'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora09() {
		return this.valorHora09;
	}

	/**
	 * Method 'setValorHora09'.
	 * 
	 * @param valorHora09
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora09(BigDecimal valorHora09) {
		this.valorHora09 = valorHora09;
	}

	/**
	 * Method 'getValorHora10'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora10() {
		return this.valorHora10;
	}

	/**
	 * Method 'setValorHora10'.
	 * 
	 * @param valorHora10
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora10(BigDecimal valorHora10) {
		this.valorHora10 = valorHora10;
	}

	/**
	 * Method 'getValorHora11'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora11() {
		return this.valorHora11;
	}

	/**
	 * Method 'setValorHora11'.
	 * 
	 * @param valorHora11
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora11(BigDecimal valorHora11) {
		this.valorHora11 = valorHora11;
	}

	/**
	 * Method 'getValorHora12'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora12() {
		return this.valorHora12;
	}

	/**
	 * Method 'setValorHora12'.
	 * 
	 * @param valorHora12
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora12(BigDecimal valorHora12) {
		this.valorHora12 = valorHora12;
	}

	/**
	 * Method 'getValorHora13'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora13() {
		return this.valorHora13;
	}

	/**
	 * Method 'setValorHora13'.
	 * 
	 * @param valorHora13
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora13(BigDecimal valorHora13) {
		this.valorHora13 = valorHora13;
	}

	/**
	 * Method 'getValorHora14'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora14() {
		return this.valorHora14;
	}

	/**
	 * Method 'setValorHora14'.
	 * 
	 * @param valorHora14
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora14(BigDecimal valorHora14) {
		this.valorHora14 = valorHora14;
	}

	/**
	 * Method 'getValorHora15'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora15() {
		return this.valorHora15;
	}

	/**
	 * Method 'setValorHora15'.
	 * 
	 * @param valorHora15
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora15(BigDecimal valorHora15) {
		this.valorHora15 = valorHora15;
	}

	/**
	 * Method 'getValorHora16'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora16() {
		return this.valorHora16;
	}

	/**
	 * Method 'setValorHora16'.
	 * 
	 * @param valorHora16
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora16(BigDecimal valorHora16) {
		this.valorHora16 = valorHora16;
	}

	/**
	 * Method 'getValorHora17'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora17() {
		return this.valorHora17;
	}

	/**
	 * Method 'setValorHora17'.
	 * 
	 * @param valorHora17
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora17(BigDecimal valorHora17) {
		this.valorHora17 = valorHora17;
	}

	/**
	 * Method 'getValorHora18'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora18() {
		return this.valorHora18;
	}

	/**
	 * Method 'setValorHora18'.
	 * 
	 * @param valorHora18
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora18(BigDecimal valorHora18) {
		this.valorHora18 = valorHora18;
	}

	/**
	 * Method 'getValorHora19'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora19() {
		return this.valorHora19;
	}

	/**
	 * Method 'setValorHora19'.
	 * 
	 * @param valorHora19
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora19(BigDecimal valorHora19) {
		this.valorHora19 = valorHora19;
	}

	/**
	 * Method 'getValorHora20'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora20() {
		return this.valorHora20;
	}

	/**
	 * Method 'setValorHora20'.
	 * 
	 * @param valorHora20
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora20(BigDecimal valorHora20) {
		this.valorHora20 = valorHora20;
	}

	/**
	 * Method 'getValorHora21'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora21() {
		return this.valorHora21;
	}

	/**
	 * Method 'setValorHora21'.
	 * 
	 * @param valorHora21
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora21(BigDecimal valorHora21) {
		this.valorHora21 = valorHora21;
	}

	/**
	 * Method 'getValorHora22'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora22() {
		return this.valorHora22;
	}

	/**
	 * Method 'setValorHora22'.
	 * 
	 * @param valorHora22
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora22(BigDecimal valorHora22) {
		this.valorHora22 = valorHora22;
	}

	/**
	 * Method 'getValorHora23'.
	 * 
	 * @return BigDecimal
	 */

	public BigDecimal getValorHora23() {
		return this.valorHora23;
	}

	/**
	 * Method 'setValorHora23'.
	 * 
	 * @param valorHora23
	 *            BigDecimal
	 * @return
	 */

	public void setValorHora23(BigDecimal valorHora23) {
		this.valorHora23 = valorHora23;
	}

	/**
	 * @return the listaContaminantes
	 */
	public List<Long> getListaContaminantes() {
		return this.listaContaminantes;
	}

	/**
	 * @param listaContaminantes
	 *            the listaContaminantes to set
	 */
	public void setListaContaminantes(List<Long> listaContaminantes) {
		this.listaContaminantes = listaContaminantes;
	}

	/**
	 * @return the listaValores
	 */
	public List<BigDecimal> getListaValores() {
		if (this.listaValores == null) {
			this.rellenarListValores();
		}
		return this.listaValores;
	}

	/**
	 * @param listaValores
	 *            the listaValores to set
	 */
	public void setListaValores(List<BigDecimal> listaValores) {
		this.listaValores = listaValores;
	}

	/**
	 * @return the ultimaMedidaHoraria
	 */
	@JsonSerialize(using = JsonDateTimeSerializer.class)
	public Date getUltimaMedidaHoraria() {
		if (this.ultimaMedidaHoraria == null) {
			this.rellenarUltimaMedidaHoraria();
		}
		return this.ultimaMedidaHoraria;
	}

	/**
	 * @param ultimaMedidaHoraria
	 *            the ultimaMedidaHoraria to set
	 */
	@JsonDeserialize(using = JsonDateTimeDeserializer.class)
	public void setUltimaMedidaHoraria(Date ultimaMedidaHoraria) {
		this.ultimaMedidaHoraria = ultimaMedidaHoraria;
	}

	/**
	 * @return the ultimoValorHorario
	 */
	public BigDecimal getUltimoValorHorario() {
		if (this.ultimoValorHorario == null) {
			this.rellenarUltimaMedidaHoraria();
		}
		return this.ultimoValorHorario;
	}

	/**
	 * @param ultimoValorHorario
	 *            the ultimoValorHorario to set
	 */
	public void setUltimoValorHorario(BigDecimal ultimoValorHorario) {
		this.ultimoValorHorario = ultimoValorHorario;
	}

	/**
	 * @return the banda
	 */
	public Aa17aBanda getBanda() {
		return this.banda;
	}

	/**
	 * @param banda
	 *            the banda to set
	 */
	public void setBanda(Aa17aBanda banda) {
		this.banda = banda;
	}

	/**
	 * @return the fechaDesde
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaDesde() {
		return this.fechaDesde;
	}

	/**
	 * @param fechaDesde
	 *            the fechaDesde to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaDesde(Date fechaDesde) {
		this.fechaDesde = fechaDesde;
	}

	/**
	 * @return the fechaHasta
	 */
	@JsonSerialize(using = JsonDateSerializer.class)
	public Date getFechaHasta() {
		return this.fechaHasta;
	}

	/**
	 * @param fechaHasta
	 *            the fechaHasta to set
	 */
	@JsonDeserialize(using = JsonDateDeserializer.class)
	public void setFechaHasta(Date fechaHasta) {
		this.fechaHasta = fechaHasta;
	}

	/**
	 * @return the fechaHoraUltimaMedidaHoraria
	 */
	public String getFechaHoraUltimaMedidaHoraria() {
		return this.fechaHoraUltimaMedidaHoraria;
	}

	/**
	 * @param fechaHoraUltimaMedidaHoraria
	 *            the fechaHoraUltimaMedidaHoraria to set
	 */
	public void setFechaHoraUltimaMedidaHoraria(String fechaHoraUltimaMedidaHoraria) {
		this.fechaHoraUltimaMedidaHoraria = fechaHoraUltimaMedidaHoraria;
	}

	/**
	 * Metodo rellenarListValores Vuelca los datos de los datos horarios de las
	 * 24 horas a una sola lista
	 */
	private void rellenarListValores() {

		List<BigDecimal> valores = new ArrayList<BigDecimal>();
		valores.add(this.getValor0SiNull(this.valorHora01));
		valores.add(this.getValor0SiNull(this.valorHora02));
		valores.add(this.getValor0SiNull(this.valorHora03));
		valores.add(this.getValor0SiNull(this.valorHora04));
		valores.add(this.getValor0SiNull(this.valorHora05));
		valores.add(this.getValor0SiNull(this.valorHora06));
		valores.add(this.getValor0SiNull(this.valorHora07));
		valores.add(this.getValor0SiNull(this.valorHora08));
		valores.add(this.getValor0SiNull(this.valorHora09));
		valores.add(this.getValor0SiNull(this.valorHora10));
		valores.add(this.getValor0SiNull(this.valorHora11));
		valores.add(this.getValor0SiNull(this.valorHora12));
		valores.add(this.getValor0SiNull(this.valorHora13));
		valores.add(this.getValor0SiNull(this.valorHora14));
		valores.add(this.getValor0SiNull(this.valorHora15));
		valores.add(this.getValor0SiNull(this.valorHora16));
		valores.add(this.getValor0SiNull(this.valorHora17));
		valores.add(this.getValor0SiNull(this.valorHora18));
		valores.add(this.getValor0SiNull(this.valorHora19));
		valores.add(this.getValor0SiNull(this.valorHora20));
		valores.add(this.getValor0SiNull(this.valorHora21));
		valores.add(this.getValor0SiNull(this.valorHora22));
		valores.add(this.getValor0SiNull(this.valorHora23));
		valores.add(this.getValor0SiNull(this.valorHora24));

		this.listaValores = valores;
	}

	/**
	 * Funcion que devuelve un 0 en caso de ser nulo
	 * 
	 * @param valor
	 *            BigDecimal
	 * @return BigDecimal
	 */
	private BigDecimal getValor0SiNull(BigDecimal valor) {
		if (valor != null) {
			return valor;
		}
		else {
			return new BigDecimal(0);
		}
	}

	/**
	 * Método que devuelve la fecha y hora de la última medición tomada
	 * 
	 */
	private void rellenarUltimaMedidaHoraria() {

		Integer hora = 0;

		if (this.getValorHora24() != null) {
			hora = Aa17aConstantes.HORA_24;
			this.setUltimoValorHorario(this.getValorHora24());
		}
		else if (this.getValorHora23() != null) {
			hora = Aa17aConstantes.HORA_23;
			this.setUltimoValorHorario(this.getValorHora23());
		}
		else if (this.getValorHora22() != null) {
			hora = Aa17aConstantes.HORA_22;
			this.setUltimoValorHorario(this.getValorHora22());
		}
		else if (this.getValorHora21() != null) {
			hora = Aa17aConstantes.HORA_21;
			this.setUltimoValorHorario(this.getValorHora21());
		}
		else if (this.getValorHora20() != null) {
			hora = Aa17aConstantes.HORA_20;
			this.setUltimoValorHorario(this.getValorHora20());
		}
		else if (this.getValorHora19() != null) {
			hora = Aa17aConstantes.HORA_19;
			this.setUltimoValorHorario(this.getValorHora19());
		}
		else if (this.getValorHora18() != null) {
			hora = Aa17aConstantes.HORA_18;
			this.setUltimoValorHorario(this.getValorHora18());
		}
		else if (this.getValorHora17() != null) {
			hora = Aa17aConstantes.HORA_17;
			this.setUltimoValorHorario(this.getValorHora17());
		}
		else if (this.getValorHora16() != null) {
			hora = Aa17aConstantes.HORA_16;
			this.setUltimoValorHorario(this.getValorHora16());
		}
		else if (this.getValorHora15() != null) {
			hora = Aa17aConstantes.HORA_15;
			this.setUltimoValorHorario(this.getValorHora15());
		}
		else if (this.getValorHora14() != null) {
			hora = Aa17aConstantes.HORA_14;
			this.setUltimoValorHorario(this.getValorHora14());
		}
		else if (this.getValorHora13() != null) {
			hora = Aa17aConstantes.HORA_13;
			this.setUltimoValorHorario(this.getValorHora13());
		}
		else if (this.getValorHora12() != null) {
			hora = Aa17aConstantes.HORA_12;
			this.setUltimoValorHorario(this.getValorHora12());
		}
		else if (this.getValorHora11() != null) {
			hora = Aa17aConstantes.HORA_11;
			this.setUltimoValorHorario(this.getValorHora11());
		}
		else if (this.getValorHora10() != null) {
			hora = Aa17aConstantes.HORA_10;
			this.setUltimoValorHorario(this.getValorHora10());
		}
		else if (this.getValorHora09() != null) {
			hora = Aa17aConstantes.HORA_09;
			this.setUltimoValorHorario(this.getValorHora09());
		}
		else if (this.getValorHora08() != null) {
			hora = Aa17aConstantes.HORA_08;
			this.setUltimoValorHorario(this.getValorHora08());
		}
		else if (this.getValorHora07() != null) {
			hora = Aa17aConstantes.HORA_07;
			this.setUltimoValorHorario(this.getValorHora07());
		}
		else if (this.getValorHora06() != null) {
			hora = Aa17aConstantes.HORA_06;
			this.setUltimoValorHorario(this.getValorHora06());
		}
		else if (this.getValorHora05() != null) {
			hora = Aa17aConstantes.HORA_05;
			this.setUltimoValorHorario(this.getValorHora05());
		}
		else if (this.getValorHora04() != null) {
			hora = Aa17aConstantes.HORA_04;
			this.setUltimoValorHorario(this.getValorHora04());
		}
		else if (this.getValorHora03() != null) {
			hora = Aa17aConstantes.HORA_03;
			this.setUltimoValorHorario(this.getValorHora03());
		}
		else if (this.getValorHora02() != null) {
			hora = Aa17aConstantes.HORA_02;
			this.setUltimoValorHorario(this.getValorHora02());
		}
		else if (this.getValorHora01() != null) {
			hora = Aa17aConstantes.HORA_01;
			this.setUltimoValorHorario(this.getValorHora01());
		}

		Calendar calendario = Calendar.getInstance();
		calendario.setTime(this.getFechaDato());
		//Si la hora son las 24, no asigno la hora al calendar porque me sumaría un dia a la fecha. Por defecto el calendar tiene las 00:00
		if (hora != Aa17aConstantes.HORA_24) {
			calendario.set(Calendar.HOUR, hora);
		}
		calendario.set(Calendar.MINUTE, Aa17aConstantes.FORMATO_MINUTO_00);
		calendario.set(Calendar.SECOND, Aa17aConstantes.FORMATO_SEGUNDO_00);

		this.setUltimaMedidaHoraria(calendario.getTime());

	}
}
